/*
Total Sims games encryption/decryption login algorithm 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


INTRODUCTION
============
The following are the encryption and the decryption algorithm used by
the games developed by iEntertainment Network (http://www.ient.com) and
that use the Total Sims login method (server arnalist.warbirdsiii.com
and port 19243).
Some of the games that use it are Armored Assault, Dawn of Aces,
Warbirds and others (look here http://www.totalsims.com).
The algorithm is a modified version of the TEA (or xTEA) encryption
algorithm using a 32bits key generated from the 32 bytes of data sent
by the server when the client connects to it (just the first data
received).
Is possible that the encryption algorithm is used also for other data
exchanged by the games however I have stopped my research to the login
only so CONTACT ME if you have more informations or packet dumps.


HOW TO USE
==========
totalsims_getkey()   for the calculation of the encryption key.
totalsims_xtea_enc() for the data encryption
totalsims_xtea_dec() for the data decryption

data is the login information sent by the client to the server.
Two full working examples are available on my Password Recovery section
of my website (search for totalsims in the page):

  http://aluigi.org/pwdrec.htm


LICENSE
=======
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/


    /* little-endian CPU only */
    /* use ntohl() and htonl() for big-endian compatibility */
#define totalsims_bswap32(x)    \
        ((((x) & 0xff000000) >> 24) | \
        (((x) & 0x00ff0000) >>  8) |  \
        (((x) & 0x0000ff00) <<  8) |  \
        (((x) & 0x000000ff) << 24))



    /* encryption */

void totalsims_xtea_enc(unsigned char *data, int size, unsigned int key) {
    unsigned int   *ptr,
                    x,
                    y,
                    sum;
    int             i;

    ptr = (unsigned int *)data;
    size >>= 3;
    while(size--) {
        x = totalsims_bswap32(ptr[0]);
        y = totalsims_bswap32(ptr[1]);
        sum = key;
        for(i = 0; i < 32; i++) {
            sum += 0x9e3779b9;
            x += (((y >> 5) ^ (y << 4)) + y) ^ sum;
            y += (((x >> 5) ^ (x << 4)) + x) ^ sum;
        }
        *ptr++ = totalsims_bswap32(x);
        *ptr++ = totalsims_bswap32(y);
    }
}



    /* decryption */

void totalsims_xtea_dec(unsigned char *data, int size, unsigned int key) {
    unsigned int   *ptr,
                    x,
                    y,
                    sum;
    int             i;

    ptr = (unsigned int *)data;
    size >>= 3;
    key += 0xc6ef3720;
    while(size--) {
        x = totalsims_bswap32(ptr[0]);
        y = totalsims_bswap32(ptr[1]);
        sum = key;
        for(i = 0; i < 32; i++) {
            y -= (((x >> 5) ^ (x << 4)) + x) ^ sum;
            x -= (((y >> 5) ^ (y << 4)) + y) ^ sum;
            sum -= 0x9e3779b9;
        }
        *ptr++ = totalsims_bswap32(x);
        *ptr++ = totalsims_bswap32(y);
    }
}



    /* key calculation */

unsigned int totalsims_getkey(unsigned char *data) {
    unsigned int   key = 0;
    unsigned int    t,
                    i;

    for(i = 0; i < 32; i++) {
        t = *data++;
        key |= (t >> (((((t >> 6) & 2) + (t & 1)) + 1) & 0xff) & 1) << i;
    }

    return(key);
}


